# 機能設計書 50-入出力操作（IO Operations）

## 概要

本ドキュメントは、TensorFlowにおける入出力操作（IO Operations）機能の設計を記述する。ファイル読み書き・TFRecordReader/Writer・テキストファイル操作を提供する。

### 本機能の処理概要

本機能は、TensorFlowの計算グラフ内でファイルシステムへの読み書き操作を行うためのOp群を提供する。チェックポイントの保存・復元、データファイルの読み込み、テンソルデータのファイル出力を含む。

**業務上の目的・背景**：機械学習パイプラインでは、（1）モデルの重みをチェックポイントとして保存・復元する、（2）訓練データをファイルから読み込む、（3）推論結果をファイルに出力する、といったI/O操作が不可欠である。本機能は、これらの操作をTensorFlowの計算グラフの一部として実行し、分散環境やデバイス配置と統合された効率的なI/Oを提供する。

**機能の利用シーン**：（1）SaveV2/RestoreV2によるチェックポイントの保存・復元場面、（2）TFRecordReader/WriterによるTFRecord形式データの読み書き場面、（3）TextLineReaderによるテキストファイルの行単位読み込み場面、（4）ReadFile/WriteFileによる汎用ファイルI/O場面、（5）MergeV2Checkpointsによるシャードされたチェックポイントの統合場面。

**主要な処理内容**：
1. SaveV2/Save/SaveSlices: テンソルをファイルに保存
2. RestoreV2/Restore/RestoreSlice: ファイルからテンソルを復元
3. MergeV2Checkpoints: 複数チェックポイントの統合
4. WholeFileReader/V2: ファイル全体の読み込み
5. TextLineReader/V2: テキストファイルの行単位読み込み
6. FixedLengthRecordReader/V2: 固定長レコードの読み込み
7. TFRecordReader/V2: TFRecord形式の読み込み
8. ReadFile/WriteFile: 汎用ファイル読み書き
9. MatchingFiles: パターンマッチによるファイル検索
10. ReaderRead/ReadUpTo/Reset等: Reader操作

**関連システム・外部連携**：ファイルシステム（ローカル、GCS、HDFS等）、チェックポイント管理（No.64）、データ入力パイプライン（No.44-49）。

**権限による制御**：ファイルシステムのアクセス権限に依存。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面機能マッピングに本機能の関連画面なし |

## 機能種別

データ連携

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| prefix | string | Yes | SaveV2の保存先プレフィックス | スカラー |
| tensor_names | string | Yes | Save用のテンソル名リスト | 1次元、テンソル数と一致 |
| shape_and_slices | string | Yes | SaveV2用のスライス仕様 | 1次元、テンソル数と一致 |
| tensors | dtypes | Yes | 保存対象のテンソル群 | 型リスト |
| filename | string | Yes | ReadFile/WriteFile用のファイル名 | スカラー |
| contents | string | Yes | WriteFile用のファイル内容 | スカラー |
| pattern | string | No | MatchingFiles用のパターン | スカラーまたは1次元 |
| reader_handle | resource | Yes | Reader操作用のリーダーハンドル | スカラー |
| queue_handle | resource | Yes | Reader操作用のキューハンドル | スカラー |

### 入力データソース

テンソルデータ、ファイルシステム上のファイル。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| tensors | dtypes | RestoreV2の復元テンソル群 |
| reader_handle | resource | Reader生成時のハンドル |
| key | string | ReaderRead時のキー |
| value | string | ReaderRead時の値 |
| contents | string | ReadFile時のファイル内容 |
| filenames | string | MatchingFiles時のファイル名リスト |
| records_produced | int64 | ReaderNumRecordsProduced時のレコード数 |

### 出力先

テンソル変数（Restore時）、ファイルシステム（Save/Write時）。

## 処理フロー

### 処理シーケンス

```
1. チェックポイント保存（SaveV2）
   └─ prefix（ファイルパス前置詞）を検証（スカラー）
   └─ tensor_names/shape_and_slicesを検証（テンソル数と一致）
   └─ 各テンソルをファイルに書き出し

2. チェックポイント復元（RestoreV2）
   └─ prefix/tensor_names/shape_and_slicesを検証
   └─ shape_and_slicesからテンソル形状を推論
   └─ ファイルからテンソルを読み込み

3. Reader操作
   └─ Reader生成（WholeFileReaderV2等）
   └─ ReaderReadV2でキュー経由でkey-valueを取得
   └─ ReaderResetV2でリーダー状態をリセット

4. 汎用ファイルI/O
   └─ ReadFile: ファイル全内容をstring型テンソルで返却
   └─ WriteFile: string型テンソルをファイルに書き出し
```

### フローチャート

```mermaid
flowchart TD
    A{I/O操作種別}
    A -->|チェックポイント保存| B[SaveV2 Op]
    A -->|チェックポイント復元| C[RestoreV2 Op]
    A -->|チェックポイント統合| D[MergeV2Checkpoints Op]
    A -->|ファイル読込| E[ReadFile Op]
    A -->|ファイル書込| F[WriteFile Op]
    A -->|Reader生成| G[TFRecordReaderV2等]
    A -->|Reader読込| H[ReaderReadV2 Op]
    A -->|ファイル検索| I[MatchingFiles Op]
    B --> J[ファイルシステム]
    C --> J
    D --> J
    E --> J
    F --> J
    G --> K[Readerハンドル]
    K --> H
    H --> L[key-value出力]
    I --> M[ファイル名リスト]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-50-01 | SaveV2テンソル一致 | tensor_namesとshape_and_slicesの要素数はtensorsの数と一致 | SaveV2実行時 |
| BR-50-02 | RestoreV2形状推論 | shape_and_slicesから出力テンソルの形状を推論。空文字列の場合は形状不明 | RestoreV2実行時 |
| BR-50-03 | ステートフルOp | Save/Restore/Reader生成/WriteFileはSetIsStateful()でステートフルとしてマーク | 常時 |
| BR-50-04 | V1非推奨 | TextLineReader/FixedLengthRecordReader/TFRecordReaderのV1版はDeprecated(26) | V1 Op使用時 |
| BR-50-05 | MergeV2の古いディレクトリ削除 | delete_old_dirs属性（デフォルトtrue）で統合後の古いチェックポイントディレクトリを削除 | MergeV2Checkpoints |

### 計算ロジック

- **SaveV2**: テンソルをshape_and_slicesに従ってスライスし、prefix配下にシャード化して保存
- **RestoreV2**: shape_and_slicesのフルシェイプとスライス仕様から出力テンソル形状を決定
- **ShardedFilename**: `sprintf("%s-%05d-of-%05d", basename, shard, num_shards)`形式のファイル名生成

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし（ファイルシステムへのI/O） |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| NotFoundError | ファイル不在 | RestoreV2で指定ファイルが存在しない | ファイルパスを確認 |
| InvalidArgumentError | 引数エラー | tensor_namesとtensorsの数が不一致 | 引数の整合性を確認 |
| InvalidArgumentError | 引数エラー | shape_and_slicesの形式が不正 | checkpoint::ParseShapeAndSliceの形式を確認 |
| PermissionDeniedError | 権限エラー | ファイルの読み書き権限がない | ファイルシステムの権限を確認 |

### リトライ仕様

ネットワークファイルシステム（GCS等）では一時的なエラーに対するリトライが内部的に実装されている。

## トランザクション仕様

- チェックポイント保存はアトミックではない。MergeV2Checkpointsで統合することで一貫性を確保
- allow_missing_files属性（MergeV2Checkpoints）で欠損ファイルを許容可能

## パフォーマンス要件

- SaveV2/RestoreV2はシャード化により並列I/Oが可能
- TFRecordReaderV2はcompression_type属性で圧縮読込みに対応
- FixedLengthRecordReaderV2はhop_bytes属性でスキップ読込みに対応

## セキュリティ考慮事項

- ファイルシステムのアクセス制御に依存
- チェックポイントファイルにはモデルの重みが含まれるため、機密性に注意
- WriteFileは任意のパスに書き込み可能であり、パストラバーサル攻撃に注意

## 備考

- V2版ReaderはresourceハンドルベースでV1のRef(string)より効率的
- LMDBReaderはLMDB形式のデータベース読み込みに対応
- IdentityReaderはテスト用のダミーリーダー
- encoding属性（FixedLengthRecordReaderV2）でファイルエンコーディングを指定可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | io_ops.cc | `tensorflow/core/ops/io_ops.cc` | I/O Opの全体構成とヘルパー関数 |

**読解のコツ**: ファイル先頭のヘルパー関数（ScalarInputsAndOutputs, TwoElementVectorAndScalarOutputs, TwoElementOutput）が、形状推論のパターンを定義している。V1版はRef(string)ハンドル、V2版はresourceハンドルを使用する。

#### Step 2: チェックポイント操作を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | io_ops.cc | `tensorflow/core/ops/io_ops.cc` | SaveV2/RestoreV2/MergeV2Checkpoints |

**主要処理フロー**:
1. **29-38行目**: ScalarInputsAndOutputs - 全入力がスカラー、全出力がスカラー
2. **40-51行目**: TwoElementVectorAndScalarOutputs - V1 Readerハンドルの形状検証
3. **60-84行目**: SaveV2 - prefix(スカラー) + tensor_names/shape_and_slices(ベクトル、テンソル数-3と一致)
4. **86-135行目**: RestoreV2 - shape_and_slicesからテンソル形状を推論
5. **137-148行目**: MergeV2Checkpoints - delete_old_dirs/allow_missing_files属性

#### Step 3: Reader操作を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | io_ops.cc | `tensorflow/core/ops/io_ops.cc` | Reader生成OpとReader操作Op |

**主要処理フロー**:
- **267-279行目**: WholeFileReaderV2 - resourceハンドル出力
- **290-296行目**: TextLineReaderV2 - skip_header_lines属性
- **310-320行目**: FixedLengthRecordReaderV2 - record_bytes/header_bytes/footer_bytes/hop_bytes/encoding
- **331-337行目**: TFRecordReaderV2 - compression_type属性
- **370-375行目**: ReaderReadV2 - reader_handleとqueue_handleからkey-valueを読み込み
- **394-409行目**: ReaderReadUpToV2 - 最大num_recordsレコードを一括読み込み

#### Step 4: 汎用ファイルI/Oを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | io_ops.cc | `tensorflow/core/ops/io_ops.cc` | ReadFile/WriteFile/MatchingFiles |

**主要処理フロー**:
- **475-478行目**: ReadFile - ファイル名(スカラー)→内容(スカラー)
- **480-489行目**: WriteFile - ファイル名+内容(スカラー)→void、IsStateful
- **491-499行目**: MatchingFiles - パターン(スカラーor1次元)→ファイル名リスト(1次元)

### プログラム呼び出し階層図

```
tf.io.write_file(filename, contents)
    │
    └─ gen_io_ops.write_file(filename, contents)
           │
           └─ WriteFile Op (C++)
                  └─ ファイルシステムへの書込み

tf.train.Checkpoint.save(file_prefix)
    │
    └─ gen_io_ops.save_v2(prefix, tensor_names, shape_and_slices, tensors)
           │
           └─ SaveV2 Op (C++)
                  └─ テンソルをシャード化して保存

tf.train.Checkpoint.restore(save_path)
    │
    └─ gen_io_ops.restore_v2(prefix, tensor_names, shape_and_slices)
           │
           └─ RestoreV2 Op (C++)
                  └─ ファイルからテンソルを復元
```

### データフロー図

```
[入力]                      [処理]                        [出力]

テンソル群 ───────────▶ SaveV2 Op ──────────▶ チェックポイントファイル
                                                    │
チェックポイントファイル ──▶ RestoreV2 Op ──────▶ テンソル群

ファイルシステム ──────▶ TFRecordReaderV2 ──▶ key-value (string)
                              + ReaderReadV2

ファイルパス ──────────▶ ReadFile Op ────────▶ ファイル内容 (string)

ファイルパターン ──────▶ MatchingFiles Op ──▶ ファイル名リスト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| io_ops.cc | `tensorflow/core/ops/io_ops.cc` | ソース(C++) | I/O Op登録と形状推論 |
| saved_tensor_slice_util.h | `tensorflow/core/util/saved_tensor_slice_util.h` | ヘッダ | ParseShapeAndSlice等のヘルパー |
| gen_io_ops.py | `tensorflow/python/ops/gen_io_ops.py` | 自動生成 | PythonバインディングWrapper |
| common_shape_fns.h | `tensorflow/core/framework/common_shape_fns.h` | ヘッダ | 形状推論共通関数 |
| checkpoint.py | `tensorflow/python/checkpoint/checkpoint.py` | ソース | チェックポイント管理（Python API） |
